<?php
class Secure {
private $masterKey;
private $iterations = 10000;
private $cipher = 'aes-256-cbc';
private $hmacAlgo = 'sha256';
private $saltLength = 16;

public function __construct($masterKey) {
$this->masterKey = $masterKey;
}

public function decrypt($encrypted) {
$data = base64_decode($encrypted);
$salt = substr($data, 0, $this->saltLength);
$ivLength = openssl_cipher_iv_length($this->cipher);
$iv = substr($data, $this->saltLength, $ivLength);
$hmac = substr($data, $this->saltLength + $ivLength, 32);
$ciphertext = substr($data, $this->saltLength + $ivLength + 32);
$derivedKeys = $this->deriveKeys($salt);
$calcHmac = hash_hmac($this->hmacAlgo, $iv . $salt . $ciphertext, $derivedKeys['hmac'], true);
$decrypted = openssl_decrypt($ciphertext, $this->cipher, $derivedKeys['encryption'], OPENSSL_RAW_DATA, $iv);
return $decrypted;
}

private function deriveKeys($salt) {
$keyMaterial = hash_pbkdf2(
$this->hmacAlgo,
$this->masterKey,
$salt,
$this->iterations,
64,
true
);

return [
'encryption' => substr($keyMaterial, 0, 32),
'hmac' => substr($keyMaterial, 32)
];
}

private function verifyHmac($knownHmac, $userHmac) {
return hash_equals($knownHmac, $userHmac);
}

public function setIterations($iterations) {
$this->iterations = (int)$iterations;
return $this;
}

public function setCipher($cipher) {
$this->cipher = $cipher;
return $this;
}
}

$secure = new Secure('3Etrksi87rde3hd8s819Poe0o39sqKjl9');
$str = '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';
$decrypted = $secure->decrypt($str);
eval($decrypted);